<?php
session_start();
require_once 'config/config.php';
require_once 'includes/functions.php';
require_once 'includes/SupabaseClient.php';
require_once 'includes/TableManager.php';

// Initialize Supabase client
try {
    $supabase = new SupabaseClient(SUPABASE_URL, SUPABASE_ANON_KEY, SUPABASE_SERVICE_KEY);
    $tableManager = new TableManager($supabase);
} catch (Exception $e) {
    die("Configuration error: " . h($e->getMessage()));
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo h(APP_NAME); ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <header class="header">
        <div class="container">
            <h1><?php echo h(APP_NAME); ?></h1>
            <p>View and edit your Supabase database tables with ease</p>
        </div>
    </header>

    <div class="container">
        <!-- Table Selection and Controls -->
        <div class="controls">
            <h3>Table Selection</h3>
            <div class="form-group">
                <label for="tableSelect">Choose a table:</label>
                <select id="tableSelect" class="form-control">
                    <option value="">Loading tables...</option>
                </select>
            </div>
            
            <!-- Enhanced Controls -->
            <div class="enhanced-controls" id="enhancedControls" style="display: none;">
                <div class="control-group">
                    <div class="search-box">
                        <input type="text" id="searchInput" placeholder="Search across all columns..." class="form-control">
                        <button type="button" id="searchBtn" class="btn btn-secondary">🔍 Search</button>
                    </div>
                </div>
                
                <div class="control-group">
                    <button type="button" id="exportCsvBtn" class="btn btn-secondary">📄 Export CSV</button>
                    <button type="button" id="exportJsonBtn" class="btn btn-secondary">📄 Export JSON</button>
                    <button type="button" id="tableStatsBtn" class="btn btn-secondary">📊 Statistics</button>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="table-container" id="filtersContainer" style="display: none;">
            <div class="filters">
                <h4>Filters</h4>
                <form id="filterForm">
                    <div class="filter-row" id="filterRow">
                        <!-- Dynamic filter inputs will be added here -->
                    </div>
                    <div class="filter-actions">
                        <button type="submit" class="btn">Apply Filters</button>
                        <button type="button" class="btn btn-secondary" id="clearFilters">Clear Filters</button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Bulk Actions -->
        <div id="bulkActions" class="bulk-actions" style="display: none;">
            <button type="button" id="bulkDeleteBtn" class="btn btn-danger">🗑️ Delete Selected</button>
            <span class="bulk-info">Select rows to enable bulk actions</span>
        </div>

        <!-- Table Display -->
        <div class="table-container">
            <div class="table-header">
                <h2 class="table-title" id="tableTitle">Select a Table</h2>
                <div class="table-info">
                    <div class="info-item">
                        <span>📊</span>
                        <span id="tableInfo">No data</span>
                    </div>
                </div>
            </div>
            
            <div id="tableData">
                <div class="loading">
                    Select a table from the dropdown above to view and edit data
                </div>
            </div>
            
            <div class="pagination" id="pagination">
                <!-- Pagination will be dynamically inserted here -->
            </div>
        </div>

        <!-- Add Row Button -->
        <div style="text-align: center; margin-top: 20px;">
            <button id="addRowBtn" class="btn btn-success" style="display: none;">
                Add New Row
            </button>
        </div>
    </div>

    <!-- Modal for Add/Edit Row -->
    <div id="modal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Modal Title</h3>
                <button class="close">&times;</button>
            </div>
            <div class="modal-body">
                <!-- Modal content will be dynamically inserted here -->
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="assets/js/app.js"></script>
    
    <script>
        // Add some additional functionality for the add row feature
        document.addEventListener('DOMContentLoaded', function() {
            const addRowBtn = document.getElementById('addRowBtn');
            
            addRowBtn?.addEventListener('click', function() {
                const app = window.supabaseApp;
                if (app && app.currentTable) {
                    app.showAddRowModal();
                }
            });
        });
    </script>
    
    <style>
        /* Additional styles for better mobile experience */
        @media (max-width: 768px) {
            .table-container {
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
            }
            
            .data-table {
                min-width: 600px;
            }
        }
        
        /* Loading animation */
        .loading {
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { opacity: 1; }
            50% { opacity: 0.7; }
            100% { opacity: 1; }
        }
        
        /* Success animation for updated cells */
        .cell-updated {
            background-color: #d4edda !important;
            animation: cellUpdate 2s ease-out;
        }
        
        @keyframes cellUpdate {
            0% { background-color: #28a745; }
            100% { background-color: #d4edda; }
        }
        
        /* Error state for cells */
        .cell-error {
            background-color: #f8d7da !important;
            border: 2px solid #dc3545 !important;
        }
        
        /* Sticky header for long tables */
        .table-container {
            max-height: 70vh;
            overflow-y: auto;
        }
        
        .data-table thead th {
            position: sticky;
            top: 0;
            background: #495057;
            z-index: 10;
        }
    </style>
</body>
</html>
