<?php
header('Content-Type: application/json');
require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/SupabaseClient.php';
require_once '../includes/TableManager.php';

try {
    // Validate request method
    if (getRequestMethod() !== 'GET') {
        throw new Exception('Only GET method allowed');
    }
    
    // Get search query
    $query = arrayGet($_GET, 'q', '');
    $table = arrayGet($_GET, 'table');
    
    if (empty($query)) {
        throw new Exception('Search query is required');
    }
    
    if (empty($table)) {
        throw new Exception('Table name is required');
    }
    
    // Initialize Supabase client
    $supabase = new SupabaseClient(SUPABASE_URL, SUPABASE_ANON_KEY, SUPABASE_SERVICE_KEY);
    $tableManager = new TableManager($supabase);
    
    // Sanitize table name
    $table = $tableManager->sanitizeTableName($table);
    
    // Get table columns
    $columns = $tableManager->getTableColumns($table);
    
    if (empty($columns)) {
        throw new Exception('Table not found or has no columns');
    }
    
    // Perform search across all columns
    $results = $tableManager->searchTable($table, $query, $columns);
    
    successResponse([
        'results' => $results,
        'query' => $query,
        'table' => $table,
        'total_results' => count($results)
    ]);
    
} catch (Exception $e) {
    logError("Error searching table: " . $e->getMessage());
    errorResponse($e->getMessage());
}
?>
