<?php
header('Content-Type: application/json');
require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/SupabaseClient.php';
require_once '../includes/TableManager.php';

try {
    // Initialize Supabase client
    $supabase = new SupabaseClient(SUPABASE_URL, SUPABASE_ANON_KEY, SUPABASE_SERVICE_KEY);
    $tableManager = new TableManager($supabase);
    
    // Get all tables
    $tables = $tableManager->getAllTables();
    
    // Filter out system tables if needed
    $filteredTables = array_filter($tables, function($table) {
        return !in_array($table, ['_realtime', 'realtime', 'auth', 'storage']);
    });
    
    successResponse([
        'tables' => array_values($filteredTables)
    ]);
    
} catch (Exception $e) {
    logError("Error getting tables: " . $e->getMessage());
    errorResponse($e->getMessage());
}
?>
