<?php
header('Content-Type: application/json');
require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/SupabaseClient.php';
require_once '../includes/TableManager.php';

try {
    // Validate request method
    if (getRequestMethod() !== 'GET') {
        throw new Exception('Only GET method allowed');
    }
    
    // Get table name
    $table = arrayGet($_GET, 'table');
    
    if (empty($table)) {
        throw new Exception('Table name is required');
    }
    
    // Initialize Supabase client
    $supabase = new SupabaseClient(SUPABASE_URL, SUPABASE_ANON_KEY, SUPABASE_SERVICE_KEY);
    $tableManager = new TableManager($supabase);
    
    // Sanitize table name
    $table = $tableManager->sanitizeTableName($table);
    
    // Get table statistics
    $stats = $tableManager->getTableStatistics($table);
    
    successResponse([
        'stats' => $stats,
        'table' => $table
    ]);
    
} catch (Exception $e) {
    logError("Error getting table statistics: " . $e->getMessage());
    errorResponse($e->getMessage());
}
?>
