<?php
header('Content-Type: application/json');
require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/SupabaseClient.php';
require_once '../includes/TableManager.php';

try {
    // Validate request method
    if (getRequestMethod() !== 'POST') {
        throw new Exception('Only POST method allowed');
    }
    
    // Get JSON input
    $input = getJsonInput();
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    // Validate required parameters
    validateRequired($input, ['table', 'data', 'format']);
    
    $table = $input['table'];
    $data = $input['data'];
    $format = $input['format']; // 'csv' or 'json'
    
    if (!in_array($format, ['csv', 'json'])) {
        throw new Exception('Invalid export format. Use csv or json');
    }
    
    // Initialize Supabase client
    $supabase = new SupabaseClient(SUPABASE_URL, SUPABASE_ANON_KEY, SUPABASE_SERVICE_KEY);
    $tableManager = new TableManager($supabase);
    
    // Sanitize table name
    $table = $tableManager->sanitizeTableName($table);
    
    // Generate export file
    $filename = $tableManager->exportTableData($table, $data, $format);
    
    successResponse([
        'filename' => $filename,
        'format' => $format,
        'records' => count($data),
        'download_url' => 'api/download_export.php?file=' . urlencode($filename)
    ]);
    
} catch (Exception $e) {
    logError("Error exporting table data: " . $e->getMessage());
    errorResponse($e->getMessage());
}
?>
