<?php
require_once '../config/config.php';
require_once '../includes/functions.php';

try {
    // Get filename from query parameter
    $filename = arrayGet($_GET, 'file');
    
    if (empty($filename)) {
        throw new Exception('No file specified');
    }
    
    // Sanitize filename to prevent directory traversal
    $filename = basename($filename);
    $filepath = __DIR__ . '/../temp/exports/' . $filename;
    
    if (!file_exists($filepath)) {
        throw new Exception('File not found');
    }
    
    // Get file info
    $fileInfo = pathinfo($filepath);
    $extension = strtolower($fileInfo['extension']);
    
    // Set appropriate headers
    switch ($extension) {
        case 'csv':
            header('Content-Type: text/csv');
            break;
        case 'json':
            header('Content-Type: application/json');
            break;
        default:
            header('Content-Type: application/octet-stream');
    }
    
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Content-Length: ' . filesize($filepath));
    header('Cache-Control: no-cache, must-revalidate');
    header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
    
    // Output file
    readfile($filepath);
    
    // Clean up - delete file after download
    unlink($filepath);
    
} catch (Exception $e) {
    http_response_code(404);
    echo "Error: " . htmlspecialchars($e->getMessage());
}
?>
