<?php
header('Content-Type: application/json');
require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/SupabaseClient.php';
require_once '../includes/TableManager.php';

try {
    // Validate request method
    if (getRequestMethod() !== 'POST') {
        throw new Exception('Only POST method allowed');
    }
    
    // Get JSON input
    $input = getJsonInput();
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    // Validate required parameters
    validateRequired($input, ['table', 'row_id']);
    
    $table = $input['table'];
    $rowId = $input['row_id'];
    $primaryKey = arrayGet($input, 'primary_key', 'id');
    
    // Initialize Supabase client
    $supabase = new SupabaseClient(SUPABASE_URL, SUPABASE_ANON_KEY, SUPABASE_SERVICE_KEY);
    $tableManager = new TableManager($supabase);
    
    // Sanitize inputs
    $table = $tableManager->sanitizeTableName($table);
    $primaryKey = $tableManager->sanitizeColumnName($primaryKey);
    
    // Validate table exists
    $columns = $tableManager->getTableColumns($table);
    
    if (empty($columns)) {
        throw new Exception('Table not found');
    }
    
    // Delete the row
    $result = $tableManager->deleteRow($table, $rowId, $primaryKey);
    
    logError("Row deleted successfully", [
        'table' => $table,
        'row_id' => $rowId,
        'primary_key' => $primaryKey
    ]);
    
    successResponse([
        'deleted' => true,
        'table' => $table,
        'row_id' => $rowId
    ], 'Row deleted successfully');
    
} catch (Exception $e) {
    logError("Error deleting row: " . $e->getMessage(), [
        'input' => $input ?? null
    ]);
    errorResponse($e->getMessage());
}
?>
