# Supabase Table Editor

A comprehensive PHP-based web application for viewing and editing Supabase database tables with an intuitive, feature-rich interface.

## ✨ Enhanced Features

### Core Functionality
- **📊 View Tables**: Display all Supabase tables in a responsive web interface
- **✏️ Edit Cells**: Click on any cell to edit its value inline with real-time updates
- **🔍 Advanced Filtering**: Apply filters to any column to find specific data quickly
- **🗑️ Row Management**: Delete individual rows or bulk delete multiple rows with confirmation
- **➕ Add Rows**: Insert new records using a dynamic form interface
- **📱 Responsive Design**: Optimized for desktop, tablet, and mobile devices

### New Enhanced Features
- **🔎 Global Search**: Search across all columns in a table simultaneously
- **📤 Data Export**: Export filtered data to CSV or JSON formats
- **📈 Table Statistics**: View detailed statistics including row counts and column information
- **☑️ Bulk Operations**: Select multiple rows for bulk delete operations
- **📊 Enhanced UI**: Improved interface with better controls and user experience
- **🎯 Smart Pagination**: Efficient handling of large datasets with intuitive navigation

## 🛠 Requirements

- PHP 7.4 or higher
- cURL extension enabled
- JSON extension enabled
- A Supabase project with API access
- Web server (Apache, Nginx, or built-in PHP server)

## 📦 Installation

### Quick Setup (Recommended)

1. **Download and Extract**: Place the package in your web server directory
2. **Run Setup**: Navigate to `setup.php` in your browser
3. **Configure**: Enter your Supabase credentials when prompted
4. **Launch**: Access `index.php` to start using the editor

### Manual Setup

1. **Clone/Download** this package to your web server directory
2. **Copy Configuration**: 
   ```bash
   cp config/config.example.php config/config.php
   ```
3. **Update Credentials**: Edit `config/config.php` with your Supabase details:
   ```php
   define('SUPABASE_URL', 'https://your-project.supabase.co');
   define('SUPABASE_ANON_KEY', 'your-anon-key');
   define('SUPABASE_SERVICE_KEY', 'your-service-role-key');
   ```
4. **Set Permissions**: Ensure the `temp/exports` directory is writable
5. **Test Installation**: Run `test.php` to verify everything is working

## 🚀 Usage Guide

### Getting Started
1. **Select a Table**: Choose from the dropdown menu
2. **View Data**: Browse your table data with pagination
3. **Apply Filters**: Use column filters to narrow down results
4. **Edit Data**: Click any cell to edit values inline

### Advanced Features

#### Global Search
- Use the search box to find data across all columns
- Search results are highlighted and easily navigable
- Clear search to return to normal table view

#### Data Export
- **CSV Export**: Download filtered data as a CSV file
- **JSON Export**: Export data in JSON format for API usage
- Export includes current filters and search results

#### Bulk Operations
- **Select Rows**: Use checkboxes to select multiple rows
- **Master Selection**: Use header checkbox to select/deselect all
- **Bulk Delete**: Delete multiple rows at once with confirmation

#### Table Statistics
- View total row and column counts
- See column names and types
- Understand your data structure at a glance

## 📁 Enhanced File Structure

```
├── index.php              # Main application interface
├── setup.php              # Interactive setup wizard
├── test.php               # System diagnostics and testing
├── config/
│   ├── config.php         # Configuration file (created during setup)
│   └── config.example.php # Example configuration template
├── includes/
│   ├── SupabaseClient.php # Enhanced Supabase API client
│   ├── TableManager.php   # Advanced table operations handler
│   └── functions.php      # Utility functions and helpers
├── assets/
│   ├── css/
│   │   └── style.css      # Enhanced responsive styles
│   └── js/
│       └── app.js         # Advanced JavaScript functionality
├── api/
│   ├── get_tables.php     # Retrieve available tables
│   ├── get_table_data.php # Get table data with filters/pagination
│   ├── get_table_stats.php # Get table statistics (NEW)
│   ├── search_tables.php  # Global search functionality (NEW)
│   ├── update_cell.php    # Update individual cell values
│   ├── delete_row.php     # Delete single row
│   ├── bulk_delete.php    # Bulk delete operations (NEW)
│   ├── add_row.php        # Add new rows
│   ├── export_table.php   # Export data to CSV/JSON (NEW)
│   └── download_export.php # Handle file downloads (NEW)
├── temp/
│   └── exports/           # Temporary export files (auto-created)
└── README.md              # This comprehensive documentation
```

## 🔧 Configuration Options

The `config/config.php` file supports these settings:

```php
// Supabase Connection
define('SUPABASE_URL', 'your-project-url');
define('SUPABASE_ANON_KEY', 'your-anonymous-key');
define('SUPABASE_SERVICE_KEY', 'your-service-role-key');

// Application Settings
define('APP_NAME', 'Supabase Table Editor');
define('DEFAULT_LIMIT', 50);  // Rows per page
define('MAX_LIMIT', 1000);    // Maximum rows per request

// Development Settings
error_reporting(E_ALL);       // Set to 0 for production
ini_set('display_errors', 1); // Set to 0 for production
```

## 🔒 Security Features

- **Input Sanitization**: All user inputs are properly sanitized
- **SQL Injection Protection**: Uses Supabase's built-in protections
- **CSRF Protection**: Includes token-based CSRF protection
- **Access Control**: Service role key is used server-side only
- **File Security**: Export files are automatically cleaned up
- **Validation**: Comprehensive server and client-side validation

## 🎨 UI/UX Features

- **Modern Design**: Clean, professional interface
- **Responsive Layout**: Works on all device sizes
- **Loading States**: Clear feedback during operations
- **Error Handling**: User-friendly error messages
- **Success Feedback**: Confirmation messages for actions
- **Intuitive Navigation**: Easy-to-use controls and menus
- **Accessibility**: Keyboard navigation and screen reader support

## 🔧 Troubleshooting

### Common Issues

1. **"Configuration Error"**
   - Run `setup.php` to configure your Supabase credentials
   - Check that `config/config.php` exists and is readable

2. **"No Tables Found"**
   - Verify your Supabase credentials are correct
   - Ensure your service role key has proper permissions
   - Check that your database has tables

3. **"Export Failed"**
   - Ensure the `temp/exports/` directory exists and is writable
   - Check PHP file permissions

4. **"Search Not Working"**
   - Verify table has data
   - Check console for JavaScript errors
   - Ensure API endpoints are accessible

### System Requirements Check

Run `test.php` to verify:
- PHP version and extensions
- File permissions
- Supabase connectivity
- API endpoint availability

## 🚀 Performance Tips

- **Pagination**: Use appropriate page sizes (50-100 rows)
- **Filtering**: Apply filters to reduce data transfer
- **Indexing**: Ensure your Supabase tables are properly indexed
- **Export Limits**: Large exports may timeout - consider filtering first

## 🔄 Updates and Maintenance

- **Regular Backups**: Always backup your data before major changes
- **Security Updates**: Keep PHP and dependencies updated
- **Monitor Usage**: Check export directory size periodically
- **Log Monitoring**: Review PHP error logs for issues

## 📝 API Reference

### Endpoints

| Endpoint | Method | Purpose |
|----------|---------|---------|
| `/api/get_tables.php` | GET | List all tables |
| `/api/get_table_data.php` | GET | Get table data with filters |
| `/api/search_tables.php` | GET | Search across columns |
| `/api/get_table_stats.php` | GET | Get table statistics |
| `/api/update_cell.php` | POST | Update cell value |
| `/api/delete_row.php` | POST | Delete single row |
| `/api/bulk_delete.php` | POST | Delete multiple rows |
| `/api/add_row.php` | POST | Add new row |
| `/api/export_table.php` | POST | Export table data |

## 🤝 Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test thoroughly
5. Submit a pull request

## 📄 License

This project is open source and available under the MIT License.

## 🙏 Acknowledgments

- Built for Supabase database platform
- Uses modern PHP and JavaScript practices
- Responsive design inspired by modern web applications

---

**Need Help?** 
- Check the troubleshooting section above
- Run `test.php` for system diagnostics  
- Review the console for JavaScript errors
- Verify Supabase credentials and permissions
